<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage core
 * @filesource
*//** */

/**
 * DPII CodeIgniter Security Class Extension
 *
 * @package		DPII
 * @author		         
 */
/**
* @package direct-as-a-service
* @subpackage core
*/
class DPII_Security extends CI_Security {
	public function __construct()
	{
		parent::__construct();
		//check for mcrypt, necessary to encrypt the CSRF cookie contents
		$mcrypt_exists = ( ! function_exists('mcrypt_encrypt')) ? FALSE : TRUE;
		if(!$mcrypt_exists) {
			show_error('Mcrypt extension must be loaded in order to use the extended Security class.');
		}
		//check for encryption key to perform cookie encryption
		if(config_item('encryption_key') == '') {
			show_error('In order to use the extended Security class, it is required that you set an encryption key in your config file.');
		}
	}
	
	/**
	 * Set Cross Site Request Forgery Protection Cookie
	 *
	 * @return	object
	 */
	public function csrf_set_cookie()
	{
		$expire = time() + $this->_csrf_expire;
		$secure_cookie = (config_item('cookie_secure') === TRUE) ? 1 : 0;

		//we are behind nginx, so check the proxy_set_header value of HTTP_HTTPS to determine if we are using HTTPS
		if ($secure_cookie && (empty($_SERVER['HTTP_HTTPS']) OR strtolower($_SERVER['HTTP_HTTPS']) === 'off'))
		{
			return FALSE;
		}
		$data = base64_encode($this->encode($this->_csrf_hash));
		setcookie($this->_csrf_cookie_name, $data, $expire, config_item('cookie_path'), config_item('cookie_domain'), $secure_cookie);

		log_message('debug', "CRSF cookie Set");

		return $this;
	}
	
	/**
	 * Set Cross Site Request Forgery Protection Cookie
	 *
	 * @return	string
	 */
	protected function _csrf_set_hash()
	{
		if ($this->_csrf_hash == '')
		{
			// If the cookie exists we will use it's value.
			// We don't necessarily want to regenerate it with
			// each page load since a page could contain embedded
			// sub-pages causing this feature to fail
			if (isset($_COOKIE[$this->_csrf_cookie_name]) &&
				preg_match('#^[0-9a-f]{64}$#iS', $this->decode(base64_decode($_COOKIE[$this->_csrf_cookie_name]))) === 1)
			{
				return $this->_csrf_hash =  $this->decode(base64_decode($_COOKIE[$this->_csrf_cookie_name]));
			}
			return $this->_csrf_hash = hash('sha256',openssl_random_pseudo_bytes(32));
		}
		return $this->_csrf_hash;
	}
	
	/**
	 * Get CSRF Hash
	 *
	 * Getter Method
	 *
	 * @return 	string 	self::_csrf_hash
	 */
	public function get_csrf_hash()
	{
		return $this->_csrf_hash;
	}
	
	
	/**
	 * Verify Cross Site Request Forgery Protection
	 *
	 * @return	object
	 */
	public function csrf_verify()
	{
		// If it's not a POST request we will set the CSRF cookie
		if (strtoupper($_SERVER['REQUEST_METHOD']) !== 'POST')
		{
			if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) &&  $_SERVER['HTTP_X_REQUESTED_WITH'] === 'XMLHttpRequest') {
				// Do the tokens exist in both the _GE   n  _COOKIE arrays?
				if ( ! isset($_GET[$this->_csrf_token_name], $_COOKIE[$this->_csrf_cookie_name]))
				{
					$this->csrf_show_error();
				}
				// Do the tokens match?
				if ($_GET[$this->_csrf_token_name] != $this->decode(base64_decode($_COOKIE[$this->_csrf_cookie_name])))
				{
					$this->csrf_show_error();
				}
			}
			return $this->csrf_set_cookie();
		}

		// Do the tokens exist in both the _POS   n  _COOKIE arrays?
		if ( ! isset($_POST[$this->_csrf_token_name], $_COOKIE[$this->_csrf_cookie_name]))
		{
			$this->csrf_show_error();
		}

		// Do the tokens match?
		if ($_POST[$this->_csrf_token_name] != $this->decode(base64_decode($_COOKIE[$this->_csrf_cookie_name])))
		{
			$this->csrf_show_error();
		}

		// We kill this since we're done and we don't want to
		// pollute the _POST array
		unset($_POST[$this->_csrf_token_name]);

		// Nothing should last forever
		unset($_COOKIE[$this->_csrf_cookie_name]);
		$this->_csrf_set_hash();
		$this->csrf_set_cookie();

		log_message('debug', 'CSRF token verified');

		return $this;
	}
	
	
	/**
	 * Custom Mcrypt AES encryption for CSRF cookie encryption
	 *
	 * @param	string
	 * @return	string
	 */
	private function encode($data) {
		$key = md5(config_item('encryption_key'));
		$init_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_CBC);
		$init_vect = mcrypt_create_iv($init_size, MCRYPT_RAND);
		return $init_vect.mcrypt_encrypt(MCRYPT_RIJNDAEL_256, $key, $data, MCRYPT_MODE_CBC, $init_vect);
	}
	
	/**
	 * Custom Mcrypt AES decryption for CSRF cookie decryption
	 *
	 * @param	string
	 * @return	string
	 */
	private function decode($data) {
		$key = md5(config_item('encryption_key'));
		$init_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_CBC);
		
		if ($init_size > strlen($data))
		{
			return FALSE;
		}
		
		$init_vect = substr($data, 0, $init_size);
		$data = substr($data, $init_size);
		return mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $key, $data, MCRYPT_MODE_CBC, $init_vect);
	}
}